/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import java.util.List;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.StyledTextIterator;
import net.sf.paperclips.TextPrint;
import net.sf.paperclips.TextStyle;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class StyledTextPrint
implements Print {
    private final List elements = new ArrayList();
    private TextStyle style = new TextStyle();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyledTextPrint other = (StyledTextPrint)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return !(this.style == null ? other.style != null : !this.style.equals(other.style));
    }

    public StyledTextPrint setStyle(TextStyle style) {
        Util.notNull(style);
        this.style = style;
        return this;
    }

    public StyledTextPrint append(String text) {
        return this.append(text, this.style);
    }

    public StyledTextPrint append(String text, TextStyle style) {
        TextPrint textPrint = new TextPrint(text, style);
        textPrint.setWordSplitting(false);
        return this.append(textPrint);
    }

    public StyledTextPrint newline() {
        return this.append(new LineBreakPrint(this.style.getFontData()));
    }

    public StyledTextPrint append(Print element) {
        this.elements.add(element);
        return this;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new StyledTextIterator(this.elements.toArray(new Print[this.elements.size()]), device, gc);
    }
}

