/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.GridCellIterator;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.PaperClipsUtil;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class GridCell {
    final int hAlignment;
    final int vAlignment;
    final Print target;
    final int colspan;

    GridCell(int hAlignment, int vAlignment, Print target, int colspan) {
        Util.notNull(target);
        this.hAlignment = GridCell.checkHorizontalAlignment(hAlignment);
        this.vAlignment = GridCell.checkVerticalAlignment(vAlignment);
        this.target = target;
        this.colspan = this.checkColspan(colspan);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.colspan;
        result = 31 * result + this.hAlignment;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + this.vAlignment;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridCell other = (GridCell)obj;
        if (this.colspan != other.colspan) {
            return false;
        }
        if (this.hAlignment != other.hAlignment) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return this.vAlignment == other.vAlignment;
    }

    public Point getAlignment() {
        return new Point(this.hAlignment, this.vAlignment);
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public Print getContent() {
        return this.target;
    }

    public int getColSpan() {
        return this.colspan;
    }

    private static int checkHorizontalAlignment(int hAlignment) {
        if ((hAlignment = PaperClipsUtil.firstMatch(hAlignment, new int[]{-1, 16384, 0x1000000, 131072}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.LEFT, SWT.CENTER, SWT.RIGHT, or SWT.DEFAULT");
        }
        return hAlignment;
    }

    private static int checkVerticalAlignment(int vAlignment) {
        if ((vAlignment = PaperClipsUtil.firstMatch(vAlignment, new int[]{-1, 128, 0x1000000, 1024, 4}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.TOP, SWT.CENTER, SWT.BOTTOM, SWT.DEFAULT, or SWT.FILL");
        }
        return vAlignment;
    }

    private int checkColspan(int colspan) {
        if (colspan <= 0 && colspan != -1) {
            PaperClips.error(5, "colspan must be a positive number or GridPrint.REMAINDER");
        }
        return colspan;
    }

    GridCellIterator iterator(Device device, GC gc) {
        return new GridCellIterator(this, device, gc);
    }
}

