/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.BackgroundPiece;
import net.sf.paperclips.BackgroundPrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class BackgroundIterator
implements PrintIterator {
    private final PrintIterator target;
    private final RGB background;
    private final Device device;

    BackgroundIterator(BackgroundPrint print, Device device, GC gc) {
        Util.notNull(print, device, gc);
        this.device = device;
        this.target = print.target.iterator(device, gc);
        this.background = print.background;
    }

    BackgroundIterator(BackgroundIterator that) {
        this.target = that.target.copy();
        this.background = that.background;
        this.device = that.device;
    }

    public Point minimumSize() {
        return this.target.minimumSize();
    }

    public Point preferredSize() {
        return this.target.preferredSize();
    }

    public boolean hasNext() {
        return this.target.hasNext();
    }

    public PrintPiece next(int width, int height) {
        PrintPiece targetPiece = PaperClips.next(this.target, width, height);
        if (targetPiece == null) {
            return null;
        }
        return new BackgroundPiece(targetPiece, this.background, this.device);
    }

    public PrintIterator copy() {
        return new BackgroundIterator(this);
    }
}

